/*
// make map_data
*/


#include <stdio.h>
#include <stdlib.h>
#include "../hland.h"

byte buffer[500000UL];

void doit(FILE* outf, char *file_naam, char* naam, long len)
{
  printf("Doing: %s\n", naam);
  {
    FILE*f;
    f=fopen(file_naam, "rb");
    if(f==NULL)
    {
      printf("File open error on %s\n",file_naam);
      exit(-1);
    }
    fread(buffer, len*2, 1, f);
    fclose(f);
  }
  {
    byte *q=buffer;
    byte *p=buffer;
    long i;
    for(i=0;i<len;i++)
    {
      byte tmp=*q++;
      switch(tmp)
      {
      case 255:
        *p++=0x78;
        break;
      case 254:
        *p++=0x70;
        break;
      case 253:
        *p++=0x1e;
        break;
      default:
        *p++=tmp;
      }
      q++;
    }
  }
  fprintf(outf, "extern signed char %s[%liUL] = {\n", naam, len);
  {
    long i;
    int w=0;
    for(i=0; i<len; i++)
    {
      fprintf(outf, "%i,", buffer[i]);
      w++;
      if(w>=16)
      {
        fprintf(outf,"\n");
        w=0;
      }
    }
  }
  fprintf(outf, "};\n");
}


int main(void)
{
  FILE*f;
  if((f=fopen("map_data.c","w"))==NULL)
  {
    printf("map data file open error!\n");
    return -1;
  }
  fprintf(f,"/*\n"
            "// file generated by: " __FILE__ "\n"
            "*/\n\n"
         );
  doit(f, "map.dat", "game_map", 54000UL);
  fclose(f);
  return 0;
}
